<?php
namespace Elementor;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Widget_z_ads_google_map2 extends Widget_Base {

    public function get_name() {
        return 'ads_google_map2_short_base';
    }

    public function get_title() {
        return __('ADs - Google Map 2','adforest-elementor');
    }

    public function get_icon() {
        return 'fa fa-audio-description';
    }

    public function get_categories() {
        return ['adforest_elementor'];
    }

    protected function _register_controls() {

       $this->start_controls_section(
                'basic', [
            'label' => esc_html__('Ads Settings','adforest-elementor'),
                ]
        );       
        
        $this->add_control(
                'ads_title', [
            'label' => __('Ads Title','adforest-elementor'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'title' => __('Section Title','adforest-elementor'),
            "description" => __("Add the title of ads that dispaly at the top of the sidebar ads listings", 'adforest-elementor'),        
            
        ]
        );
        
        $this->add_control(
                'ad_type', array(
            'label' => __('Ads Type','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Select Ads Type','adforest-elementor'),
                'feature' => __('Featured Ads','adforest-elementor'),
                'regular' => __('Simple Ads','adforest-elementor'),
                'both' => __('Both','adforest-elementor'),
            ),
                )
        );
        
         $this->add_control(
                'ad_order', array(
            'label' => __('Order By','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                '' => __('Select Ads order','adforest-elementor'),
                'asc' => __('Oldest','adforest-elementor'),
                'desc' => __('Latest','adforest-elementor'),
                'rand' => __('Random','adforest-elementor'),
            ),
                )
        );
         
        $this->add_control(
			'no_of_ads',
			[
				'label' => __( 'Number fo Ads for each category','adforest-elementor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 500,
				'step' => 1,
				'default' => 1,
			]
		); 
        
       

        $this->end_controls_section();

        $this->start_controls_section(
                     'maps', [
                 'label' => esc_html__('Map','adforest-elementor'),
                     ]
             );

           $this->add_control(
                     'map_marker_img', array(
                 'label' => __('Map Marker','adforest-elementor'),
                 'type' => Controls_Manager::MEDIA,
                 'description' => __('50x77','adforest-elementor'),
                 'default' => array(
                     'url' => \Elementor\Utils::get_placeholder_image_src(),
                 ),
                     )
             );
           $this->add_control(
                     'map_marker_more_img', array(
                 'label' => __('Map Marker Many','adforest-elementor'),
                 'type' => Controls_Manager::MEDIA,
                 'description' => __('50x77','adforest-elementor'),
                 'default' => array(
                     'url' => \Elementor\Utils::get_placeholder_image_src(),
                 ),
                     )
             );

           $this->add_control(
                             'map_zoom',
                             [
                                     'label' => __( 'Map Zoom','adforest-elementor' ),
                                     'type' => \Elementor\Controls_Manager::NUMBER,
                                     'min' => 1,
                                     'max' => 12,
                                     'step' => 1,
                                     'default' => 1,
                             ]
                     ); 


              $this->add_control(
                     'map_latitude', [
                 'label' => __('Latitude','adforest-elementor'),
                 'type' => Controls_Manager::TEXT,
                 'default' => '',
                 'title' => __('Section Title','adforest-elementor'),
                 "description" => __("That Area will be display in map after loading but user can change it by dragging", 'adforest-elementor'),        

             ]
             );
             $this->add_control(
                     'map_longitude', [
                 'label' => __('Longitude','adforest-elementor'),
                 'type' => Controls_Manager::TEXT,
                 'default' => '',
                 'title' => __('Section Title','adforest-elementor'),


             ]
             );

             $this->add_control(
                     'map_info_address_limit', [
                 'label' => __('Map infobox address limit','adforest-elementor'),
                 'type' => Controls_Manager::TEXT,
                 'default' => '',
                 'title' => __('Section Title','adforest-elementor'),
                 "description" => __("Add the title of ads that dispaly at the top of the sidebar ads listings", 'adforest-elementor'),        

             ]
             );

             $this->end_controls_section();

        
        
        $this->start_controls_section(
                'tabers', [
            'label' => esc_html__('Categories','adforest-elementor'),
                ]
        );
        
      
        
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
                'cat', array(
            'label' => __('Select Category','adforest-elementor'),
            'type' => Controls_Manager::SELECT,
            //'multiple' => true,        
            'options' => apply_filters('adforest_elementor_ads_categories', array(), 'ad_cats'),
            
       )
       ); 
        
        
         $repeater->add_control(
                'img', array(
            'label' => __('Category Marker Image','adforest-elementor'),
            'type' => Controls_Manager::MEDIA,
            'description' => __('80x120','adforest-elementor'),
            'default' => array(
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ),
                )
        );
     
         $this->add_control(
                'cats', [
            'label' => __('Select Category','adforest-elementor'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'description' => __('Category: Beagle (beagle)','adforest-elementor'),
            'fields' => $repeater->get_controls(),
            'default' => [],
                //'title_field' => '{{{  }}}',
                ]
        );
         
         
       $this->end_controls_section(); 
        
        
        

    }

    protected function render() {
        
         $package_settings_fields = $this->get_settings_for_display();
        $adforest_render_params = array();
        // basic
        $adforest_render_params['adforest_elementor'] = TRUE; 
        
        $adforest_render_params['ads_title'] = isset($package_settings_fields['ads_title']) ? $package_settings_fields['ads_title'] : '';
        $adforest_render_params['ad_type'] = isset($package_settings_fields['ad_type']) ? $package_settings_fields['ad_type'] : '';
        $adforest_render_params['ad_order'] = isset($package_settings_fields['ad_order']) ? $package_settings_fields['ad_order'] : '';
        $adforest_render_params['no_of_ads'] = isset($package_settings_fields['no_of_ads']) ? $package_settings_fields['no_of_ads'] : '';
        
        $adforest_render_params['map_marker_img'] = isset($package_settings_fields['map_marker_img']['id']) ? $package_settings_fields['map_marker_img']['id'] : '';
        $adforest_render_params['map_marker_more_img'] = isset($package_settings_fields['map_marker_more_img']['id']) ? $package_settings_fields['map_marker_more_img']['id'] : '';
        $adforest_render_params['map_zoom'] = isset($package_settings_fields['map_zoom']) ? $package_settings_fields['map_zoom'] : '';
        $adforest_render_params['map_latitude'] = isset($package_settings_fields['map_latitude']) ? $package_settings_fields['map_latitude'] : '';
        $adforest_render_params['map_longitude'] = isset($package_settings_fields['map_longitude']) ? $package_settings_fields['map_longitude'] : '';
        $adforest_render_params['map_info_address_limit'] = isset($package_settings_fields['map_info_address_limit']) ? $package_settings_fields['map_info_address_limit'] : '';
       
        $adforest_render_params['cats'] = isset($package_settings_fields['cats']) ? $package_settings_fields['cats'] : '';
       
             
         echo ads_google_map2_short_base_func($adforest_render_params);
        
    }
}