# Contributing to `twilio-php`

We'd love for you to contribute to our source code and to make `twilio-php`
even better than it is today! Here are the guidelines we'd like you to follow:

 - [Code of Conduct](#coc)
 - [Question or Problem?](#question)
 - [Issues and Bugs](#issue)
 - [Feature Requests](#feature)
 - [Documentation fixes](#docs)
 - [Submission Guidelines](#submit)
 - [Coding Rules](#rules)
 - [Local Testing with Docker](#testing)


## <a name="coc"></a> Code of Conduct

Help us keep `twilio-php` open and inclusive. Please be kind to and considerate
of other developers, as we all have the same goal: make `twilio-php` as good as
it can be.

## <a name="question"></a> Got an API/Product Question or Problem?

If you have questions about how to use `twilio-php`, please see our
[docs][docs-link], and if you don't find the answer there, please contact
[help@twilio.com](mailto:help@twilio.com) with any issues you have.

## <a name="issue"></a> Found an Issue?

If you find a bug in the source code or a mistake in the documentation, you can
help us by submitting [an issue][issue-link]. If the file in which the error
exists has this header:
```
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""
```
then it is a generated file and the change will need to be made by us, but
submitting an issue will help us track it and keep you up-to-date. If the file
isn't generated, you can help us out even more by submitting a Pull Request with
a fix.

**Please see the [Submission Guidelines](#submit) below.**

## <a name="feature"></a> Want a Feature?

You can request a new feature by submitting an issue to our
[GitHub Repository][github]. If you would like to implement a new feature then
consider what kind of change it is:

* **Major Changes** that you wish to contribute to the project should be
  discussed first with `twilio-php` contributors in an issue or pull request so
  that we can develop a proper solution and better coordinate our efforts,
  prevent duplication of work, and help you to craft the change so that it is
  successfully accepted into the project.
* **Small Changes** can be crafted and submitted to the
  [GitHub Repository][github] as a Pull Request.

## <a name="docs"></a> Want a Doc Fix?

If you want to help improve the docs in the helper library, it's a good idea to
let others know what you're working on to minimize duplication of effort. Create
a new issue (or comment on a related existing one) to let others know what
you're working on.

For large fixes, please build and test the documentation before submitting the
PR to be sure you haven't accidentally introduced layout or formatting issues.

If you want to help improve the docs at
[https://www.twilio.com/docs/libraries/php][docs-link], please contact
[help@twilio.com](mailto:help@twilio.com).

## <a name="submit"></a> Submission Guidelines

### Submitting an Issue
Before you submit your issue search the archive, maybe your question was already
answered.

If your issue appears to be a bug, and hasn't been reported, open a new issue.
Help us to maximize the effort we can spend fixing issues and adding new
features by not reporting duplicate issues. Providing the following information
will increase the chances of your issue being dealt with quickly:

* **Overview of the Issue** - if an error is being thrown a non-minified stack
  trace helps
* **Motivation for or Use Case** - explain why this is a bug for you
* **`twilio-php` Version(s)** - is it a regression?
* **Operating System (if relevant)** - is this a problem with all systems or
  only specific ones?
* **Reproduce the Error** - provide an isolated code snippet or an unambiguous
  set of steps.
* **Related Issues** - has a similar issue been reported before?
* **Suggest a Fix** - if you can't fix the bug yourself, perhaps you can point
  to what might be causing the problem (line of code or commit)

**If you get help, help others. Good karma rules!**

### Submitting a Pull Request
Before you submit your pull request consider the following guidelines:

* Search [GitHub][github] for an open or closed Pull Request that relates to
  your submission. You don't want to duplicate effort.
* Make your changes in a new git branch:

    ```shell
    git checkout -b my-fix-branch master
    ```

* Create your patch, **including appropriate test cases**.
* Follow our [Coding Rules](#rules).
* Run the full `twilio-php` test suite (aliased by `make test`), and ensure
  that all tests pass.
* Commit your changes using a descriptive commit message.

    ```shell
    git commit -a
    ```
  Note: the optional commit `-a` command line option will automatically "add"
  and "rm" edited files.

* Build your changes locally to ensure all the tests pass:

    ```shell
    make test
    ```

* Push your branch to GitHub:

    ```shell
    git push origin my-fix-branch
    ```

In GitHub, send a pull request to `twilio-php:master`.
If we suggest changes, then:

* Make the required updates.
* Re-run the `twilio-php` test suite to ensure tests are still passing.
* Commit your changes to your branch (e.g. `my-fix-branch`).
* Push the changes to your GitHub repository (this will update your Pull Request).

That's it! Thank you for your contribution!

#### After your pull request is merged

After your pull request is merged, you can safely delete your branch and pull
the changes from the main (upstream) repository.

## <a name="rules"></a> Coding Rules

To ensure consistency throughout the source code, keep these rules in mind as
you are working:

* All features or bug fixes **must be tested** by one or more tests.
* All classes and methods **must be documented**.

## <a name="testing"></a> Local Testing with Docker
We have included a [Dockerfile](https://github.com/twilio/twilio-php/blob/master/Dockerfile-dev) that enables easy local testing, given a specified PHP version.

Sample simple workflow:
1. `git clone https://github.com/twilio/twilio-php.git`
1. `cd twilio-php`
1. `make install`
1. `make docker-dev-build VERSION=7.4-rc`
1. `make docker-dev-test VERSION=7.4-rc`
1. Modify code
1. `make docker-dev-test VERSION=7.4-rc`

Tested versions: 7.1.32, 7.2.22, 7.3.9 and 7.4-rc. A complete list of supported PHP versions can be found at the [Docker docs page](https://docs.docker.com/samples/library/php).

[docs-link]: https://www.twilio.com/docs/libraries/php
[issue-link]: https://github.com/twilio/twilio-php/issues/new
[github]: https://github.com/twilio/twilio-php