<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Options;
use Twilio\Values;

abstract class CallSummariesOptions {
    /**
     * @param string[] $from The from
     * @param string[] $to The to
     * @param string[] $fromCarrier The from_carrier
     * @param string[] $toCarrier The to_carrier
     * @param string[] $fromCountryCode The from_country_code
     * @param string[] $toCountryCode The to_country_code
     * @param bool $branded The branded
     * @param bool $verifiedCaller The verified_caller
     * @param bool $hasTag The has_tag
     * @param string $startTime The start_time
     * @param string $endTime The end_time
     * @param string[] $callType The call_type
     * @param string[] $callState The call_state
     * @param string $direction The direction
     * @param string $processingState The processing_state
     * @param string $sortBy The sort_by
     * @param string $subaccount The subaccount
     * @param bool $abnormalSession The abnormal_session
     * @return ReadCallSummariesOptions Options builder
     */
    public static function read(array $from = Values::ARRAY_NONE, array $to = Values::ARRAY_NONE, array $fromCarrier = Values::ARRAY_NONE, array $toCarrier = Values::ARRAY_NONE, array $fromCountryCode = Values::ARRAY_NONE, array $toCountryCode = Values::ARRAY_NONE, bool $branded = Values::NONE, bool $verifiedCaller = Values::NONE, bool $hasTag = Values::NONE, string $startTime = Values::NONE, string $endTime = Values::NONE, array $callType = Values::ARRAY_NONE, array $callState = Values::ARRAY_NONE, string $direction = Values::NONE, string $processingState = Values::NONE, string $sortBy = Values::NONE, string $subaccount = Values::NONE, bool $abnormalSession = Values::NONE): ReadCallSummariesOptions {
        return new ReadCallSummariesOptions($from, $to, $fromCarrier, $toCarrier, $fromCountryCode, $toCountryCode, $branded, $verifiedCaller, $hasTag, $startTime, $endTime, $callType, $callState, $direction, $processingState, $sortBy, $subaccount, $abnormalSession);
    }
}

class ReadCallSummariesOptions extends Options {
    /**
     * @param string[] $from The from
     * @param string[] $to The to
     * @param string[] $fromCarrier The from_carrier
     * @param string[] $toCarrier The to_carrier
     * @param string[] $fromCountryCode The from_country_code
     * @param string[] $toCountryCode The to_country_code
     * @param bool $branded The branded
     * @param bool $verifiedCaller The verified_caller
     * @param bool $hasTag The has_tag
     * @param string $startTime The start_time
     * @param string $endTime The end_time
     * @param string[] $callType The call_type
     * @param string[] $callState The call_state
     * @param string $direction The direction
     * @param string $processingState The processing_state
     * @param string $sortBy The sort_by
     * @param string $subaccount The subaccount
     * @param bool $abnormalSession The abnormal_session
     */
    public function __construct(array $from = Values::ARRAY_NONE, array $to = Values::ARRAY_NONE, array $fromCarrier = Values::ARRAY_NONE, array $toCarrier = Values::ARRAY_NONE, array $fromCountryCode = Values::ARRAY_NONE, array $toCountryCode = Values::ARRAY_NONE, bool $branded = Values::NONE, bool $verifiedCaller = Values::NONE, bool $hasTag = Values::NONE, string $startTime = Values::NONE, string $endTime = Values::NONE, array $callType = Values::ARRAY_NONE, array $callState = Values::ARRAY_NONE, string $direction = Values::NONE, string $processingState = Values::NONE, string $sortBy = Values::NONE, string $subaccount = Values::NONE, bool $abnormalSession = Values::NONE) {
        $this->options['from'] = $from;
        $this->options['to'] = $to;
        $this->options['fromCarrier'] = $fromCarrier;
        $this->options['toCarrier'] = $toCarrier;
        $this->options['fromCountryCode'] = $fromCountryCode;
        $this->options['toCountryCode'] = $toCountryCode;
        $this->options['branded'] = $branded;
        $this->options['verifiedCaller'] = $verifiedCaller;
        $this->options['hasTag'] = $hasTag;
        $this->options['startTime'] = $startTime;
        $this->options['endTime'] = $endTime;
        $this->options['callType'] = $callType;
        $this->options['callState'] = $callState;
        $this->options['direction'] = $direction;
        $this->options['processingState'] = $processingState;
        $this->options['sortBy'] = $sortBy;
        $this->options['subaccount'] = $subaccount;
        $this->options['abnormalSession'] = $abnormalSession;
    }

    /**
     * The from
     *
     * @param string[] $from The from
     * @return $this Fluent Builder
     */
    public function setFrom(array $from): self {
        $this->options['from'] = $from;
        return $this;
    }

    /**
     * The to
     *
     * @param string[] $to The to
     * @return $this Fluent Builder
     */
    public function setTo(array $to): self {
        $this->options['to'] = $to;
        return $this;
    }

    /**
     * The from_carrier
     *
     * @param string[] $fromCarrier The from_carrier
     * @return $this Fluent Builder
     */
    public function setFromCarrier(array $fromCarrier): self {
        $this->options['fromCarrier'] = $fromCarrier;
        return $this;
    }

    /**
     * The to_carrier
     *
     * @param string[] $toCarrier The to_carrier
     * @return $this Fluent Builder
     */
    public function setToCarrier(array $toCarrier): self {
        $this->options['toCarrier'] = $toCarrier;
        return $this;
    }

    /**
     * The from_country_code
     *
     * @param string[] $fromCountryCode The from_country_code
     * @return $this Fluent Builder
     */
    public function setFromCountryCode(array $fromCountryCode): self {
        $this->options['fromCountryCode'] = $fromCountryCode;
        return $this;
    }

    /**
     * The to_country_code
     *
     * @param string[] $toCountryCode The to_country_code
     * @return $this Fluent Builder
     */
    public function setToCountryCode(array $toCountryCode): self {
        $this->options['toCountryCode'] = $toCountryCode;
        return $this;
    }

    /**
     * The branded
     *
     * @param bool $branded The branded
     * @return $this Fluent Builder
     */
    public function setBranded(bool $branded): self {
        $this->options['branded'] = $branded;
        return $this;
    }

    /**
     * The verified_caller
     *
     * @param bool $verifiedCaller The verified_caller
     * @return $this Fluent Builder
     */
    public function setVerifiedCaller(bool $verifiedCaller): self {
        $this->options['verifiedCaller'] = $verifiedCaller;
        return $this;
    }

    /**
     * The has_tag
     *
     * @param bool $hasTag The has_tag
     * @return $this Fluent Builder
     */
    public function setHasTag(bool $hasTag): self {
        $this->options['hasTag'] = $hasTag;
        return $this;
    }

    /**
     * The start_time
     *
     * @param string $startTime The start_time
     * @return $this Fluent Builder
     */
    public function setStartTime(string $startTime): self {
        $this->options['startTime'] = $startTime;
        return $this;
    }

    /**
     * The end_time
     *
     * @param string $endTime The end_time
     * @return $this Fluent Builder
     */
    public function setEndTime(string $endTime): self {
        $this->options['endTime'] = $endTime;
        return $this;
    }

    /**
     * The call_type
     *
     * @param string[] $callType The call_type
     * @return $this Fluent Builder
     */
    public function setCallType(array $callType): self {
        $this->options['callType'] = $callType;
        return $this;
    }

    /**
     * The call_state
     *
     * @param string[] $callState The call_state
     * @return $this Fluent Builder
     */
    public function setCallState(array $callState): self {
        $this->options['callState'] = $callState;
        return $this;
    }

    /**
     * The direction
     *
     * @param string $direction The direction
     * @return $this Fluent Builder
     */
    public function setDirection(string $direction): self {
        $this->options['direction'] = $direction;
        return $this;
    }

    /**
     * The processing_state
     *
     * @param string $processingState The processing_state
     * @return $this Fluent Builder
     */
    public function setProcessingState(string $processingState): self {
        $this->options['processingState'] = $processingState;
        return $this;
    }

    /**
     * The sort_by
     *
     * @param string $sortBy The sort_by
     * @return $this Fluent Builder
     */
    public function setSortBy(string $sortBy): self {
        $this->options['sortBy'] = $sortBy;
        return $this;
    }

    /**
     * The subaccount
     *
     * @param string $subaccount The subaccount
     * @return $this Fluent Builder
     */
    public function setSubaccount(string $subaccount): self {
        $this->options['subaccount'] = $subaccount;
        return $this;
    }

    /**
     * The abnormal_session
     *
     * @param bool $abnormalSession The abnormal_session
     * @return $this Fluent Builder
     */
    public function setAbnormalSession(bool $abnormalSession): self {
        $this->options['abnormalSession'] = $abnormalSession;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.ReadCallSummariesOptions ' . $options . ']';
    }
}