<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Messaging\V1;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class WebhookTest extends HolodeckTestCase {
    public function testFetchRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->messaging->v1->webhooks()->fetch();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://messaging.twilio.com/v1/Sessions/Webhooks'
        ));
    }

    public function testFetchResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "pre_webhook_url": "http://pre.url",
                "post_webhook_url": "http://post.url",
                "webhook_method": "GET",
                "webhook_filters": [
                    "onMessageSend",
                    "onSessionAdded"
                ],
                "pre_webhook_retry_count": 1,
                "post_webhook_retry_count": 2,
                "target": "http",
                "url": "https://messaging.twilio.com/v1/Sessions/Webhooks"
            }
            '
        ));

        $actual = $this->twilio->messaging->v1->webhooks()->fetch();

        $this->assertNotNull($actual);
    }

    public function testUpdateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->messaging->v1->webhooks()->update();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'post',
            'https://messaging.twilio.com/v1/Sessions/Webhooks'
        ));
    }

    public function testUpdateResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "service_sid": "ISaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "pre_webhook_url": "http://pre.url",
                "post_webhook_url": "http://post.url",
                "webhook_method": "GET",
                "webhook_filters": [
                    "onSessionAdded"
                ],
                "pre_webhook_retry_count": 1,
                "post_webhook_retry_count": 2,
                "target": "flex",
                "url": "https://messaging.twilio.com/v1/Sessions/Webhooks"
            }
            '
        ));

        $actual = $this->twilio->messaging->v1->webhooks()->update();

        $this->assertNotNull($actual);
    }
}