<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Preview\Trustedcomms;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class BrandedCallTest extends HolodeckTestCase {
    public function testCreateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->preview->trustedComms->brandedCalls->create("from", "to", "reason");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('From' => "from", 'To' => "to", 'Reason' => "reason", );

        $this->assertRequest(new Request(
            'post',
            'https://preview.twilio.com/TrustedComms/Business/BrandedCalls',
            null,
            $values
        ));
    }

    public function testCreateResponse() {
        $this->holodeck->mock(new Response(
            201,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "bg_color": "#fff",
                "brand_sid": "BZaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "branded_channel_sid": "BWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "business_sid": "BXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "call_sid": "CAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "caller": "Owl Bank",
                "created_at": "2019-05-01T20:00:00Z",
                "font_color": "#000",
                "from": "+15000000000",
                "logo": "https://www.twilio.com/marketing/bundles/company/img/logos/red/twilio-logo-red.png",
                "phone_number_sid": "PNaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "reason": "Hello Jhon, your appointment has been confirmed.",
                "sid": "CQaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "unknown",
                "to": "+573000000000",
                "use_case": "conversational",
                "url": "https://preview.twilio.com/TrustedComms/Business/BrandedCalls"
            }
            '
        ));

        $actual = $this->twilio->preview->trustedComms->brandedCalls->create("from", "to", "reason");

        $this->assertNotNull($actual);
    }
}