<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Preview\Trustedcomms;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class DeviceTest extends HolodeckTestCase {
    public function testCreateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->preview->trustedComms->devices->create("phone_number", "push_token");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('PhoneNumber' => "phone_number", 'PushToken' => "push_token", );

        $this->assertRequest(new Request(
            'post',
            'https://preview.twilio.com/TrustedComms/Devices',
            null,
            $values
        ));
    }

    public function testCreateResponse() {
        $this->holodeck->mock(new Response(
            201,
            '
            {
                "binding_sid": "BSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "phone_number": "+573000000000",
                "sid": "DDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://preview.twilio.com/TrustedComms/Devices"
            }
            '
        ));

        $actual = $this->twilio->preview->trustedComms->devices->create("phone_number", "push_token");

        $this->assertNotNull($actual);
    }
}