<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Pricing\V2\Voice;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class CountryTest extends HolodeckTestCase {
    public function testReadRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->pricing->v2->voice
                                      ->countries->read();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://pricing.twilio.com/v2/Voice/Countries'
        ));
    }

    public function testReadFullResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "countries": [
                    {
                        "country": "Andorra",
                        "iso_country": "AD",
                        "url": "https://pricing.twilio.com/v2/Voice/Countries/AD"
                    }
                ],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v2/Voice/Countries?PageSize=50&Page=0",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v2/Voice/Countries?PageSize=50&Page=0"
                }
            }
            '
        ));

        $actual = $this->twilio->pricing->v2->voice
                                            ->countries->read();

        $this->assertGreaterThan(0, \count($actual));
    }

    public function testReadEmptyResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "countries": [],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v2/Voice/Countries?PageSize=50&Page=0",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v2/Voice/Countries?PageSize=50&Page=0"
                }
            }
            '
        ));

        $actual = $this->twilio->pricing->v2->voice
                                            ->countries->read();

        $this->assertNotNull($actual);
    }

    public function testFetchRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->pricing->v2->voice
                                      ->countries("US")->fetch();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://pricing.twilio.com/v2/Voice/Countries/US'
        ));
    }

    public function testFetchResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "country": "United States",
                "inbound_call_prices": [
                    {
                        "base_price": "0.0085",
                        "current_price": "0.0085",
                        "number_type": "local"
                    },
                    {
                        "base_price": "0.022",
                        "current_price": "0.022",
                        "number_type": "toll free"
                    }
                ],
                "iso_country": "US",
                "outbound_prefix_prices": [
                    {
                        "base_price": "0.090",
                        "current_price": "0.090",
                        "destination_prefixes": [
                            "1907"
                        ],
                        "friendly_name": "Programmable Outbound Minute - United States - Alaska",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": "0.013",
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1808"
                        ],
                        "friendly_name": "Programmable Outbound Minute - United States - Hawaii",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": "0.013",
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1800",
                            "1844",
                            "1855",
                            "1866",
                            "1877",
                            "1888"
                        ],
                        "friendly_name": "Programmable Outbound Minute - United States & Canada - Toll Free",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": "0.013",
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1"
                        ],
                        "friendly_name": "Programmable Outbound Minute - United States & Canada",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "https://pricing.twilio.com/v2/Voice/Countries/US"
            }
            '
        ));

        $actual = $this->twilio->pricing->v2->voice
                                            ->countries("US")->fetch();

        $this->assertNotNull($actual);
    }
}