<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Video\V1;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class CompositionHookTest extends HolodeckTestCase {
    public function testFetchRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->fetch();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://video.twilio.com/v1/CompositionHooks/HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
        ));
    }

    public function testFetchResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "My composition hook",
                "enabled": true,
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:01:33Z",
                "sid": "HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "user*"
                ],
                "audio_sources_excluded": [
                    "moderator*"
                ],
                "video_layout": {
                    "grid": {
                        "video_sources": [
                            "*"
                        ],
                        "video_sources_excluded": [
                            "moderator*"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    },
                    "pip": {
                        "video_sources": [
                            "student*"
                        ],
                        "video_sources_excluded": [],
                        "reuse": "none",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    }
                },
                "resolution": "1280x720",
                "format": "webm",
                "trim": true,
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "url": "https://video.twilio.com/v1/CompositionHooks/HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->fetch();

        $this->assertNotNull($actual);
    }

    public function testReadRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositionHooks->read();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://video.twilio.com/v1/CompositionHooks'
        ));
    }

    public function testReadEmptyResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "composition_hooks": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/CompositionHooks?Enabled=True&PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/CompositionHooks?Enabled=True&PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "composition_hooks"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks->read();

        $this->assertNotNull($actual);
    }

    public function testReadResultsResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "composition_hooks": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "My Special Hook1",
                        "enabled": true,
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_updated": "2015-07-30T20:01:33Z",
                        "sid": "HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "audio_sources": [
                            "*"
                        ],
                        "audio_sources_excluded": [],
                        "video_layout": {
                            "grid": {
                                "video_sources": [
                                    "*"
                                ],
                                "video_sources_excluded": [
                                    "moderator*"
                                ],
                                "reuse": "show_oldest",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            },
                            "pip": {
                                "video_sources": [
                                    "student*"
                                ],
                                "video_sources_excluded": [],
                                "reuse": "none",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            }
                        },
                        "resolution": "1280x720",
                        "format": "webm",
                        "trim": true,
                        "status_callback": "http://www.example.com",
                        "status_callback_method": "POST",
                        "url": "https://video.twilio.com/v1/CompositionHooks/HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/CompositionHooks?FriendlyName=%2AHook%2A&DateCreatedBefore=2017-12-31T23%3A59%3A59Z&DateCreatedAfter=2017-01-01T00%3A00%3A01Z&Enabled=True&PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/CompositionHooks?FriendlyName=%2AHook%2A&DateCreatedBefore=2017-12-31T23%3A59%3A59Z&DateCreatedAfter=2017-01-01T00%3A00%3A01Z&Enabled=True&PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "composition_hooks"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks->read();

        $this->assertNotNull($actual);
    }

    public function testDeleteRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->delete();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'delete',
            'https://video.twilio.com/v1/CompositionHooks/HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
        ));
    }

    public function testDeleteResponse() {
        $this->holodeck->mock(new Response(
            204,
            null
        ));

        $actual = $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->delete();

        $this->assertTrue($actual);
    }

    public function testCreateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositionHooks->create("friendly_name");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('FriendlyName' => "friendly_name", );

        $this->assertRequest(new Request(
            'post',
            'https://video.twilio.com/v1/CompositionHooks',
            null,
            $values
        ));
    }

    public function testCreateResponse() {
        $this->holodeck->mock(new Response(
            201,
            '
            {
                "friendly_name": "My composition hook",
                "enabled": false,
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": null,
                "sid": "HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "user*",
                    "moderator"
                ],
                "audio_sources_excluded": [
                    "admin"
                ],
                "video_layout": {
                    "custom": {
                        "video_sources": [
                            "user*"
                        ],
                        "video_sources_excluded": [
                            "moderator"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 800,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": [
                            2,
                            3
                        ]
                    }
                },
                "trim": true,
                "format": "mp4",
                "resolution": "1280x720",
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "url": "https://video.twilio.com/v1/CompositionHooks/HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks->create("friendly_name");

        $this->assertNotNull($actual);
    }

    public function testUpdateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->update("friendly_name");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('FriendlyName' => "friendly_name", );

        $this->assertRequest(new Request(
            'post',
            'https://video.twilio.com/v1/CompositionHooks/HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
            null,
            $values
        ));
    }

    public function testUpdateAllFieldsResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "friendly_name": "My composition hook",
                "enabled": true,
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:00:00Z",
                "sid": "HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "user*",
                    "moderator"
                ],
                "audio_sources_excluded": [
                    "admin"
                ],
                "video_layout": {
                    "custom": {
                        "video_sources": [
                            "user*"
                        ],
                        "video_sources_excluded": [
                            "moderator"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 800,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": [
                            2,
                            3
                        ]
                    }
                },
                "trim": true,
                "format": "mp4",
                "resolution": "1280x720",
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "url": "https://video.twilio.com/v1/CompositionHooks/HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->update("friendly_name");

        $this->assertNotNull($actual);
    }

    public function testUpdateWithDefaultsResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "friendly_name": "My composition hook",
                "enabled": true,
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:00:00Z",
                "sid": "HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "user*",
                    "moderator"
                ],
                "audio_sources_excluded": [
                    "admin"
                ],
                "video_layout": {},
                "trim": true,
                "format": "mp4",
                "resolution": "1280x720",
                "status_callback": null,
                "status_callback_method": "POST",
                "url": "https://video.twilio.com/v1/CompositionHooks/HKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositionHooks("HKXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->update("friendly_name");

        $this->assertNotNull($actual);
    }
}