<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Video\V1;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class CompositionTest extends HolodeckTestCase {
    public function testFetchRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositions("CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->fetch();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://video.twilio.com/v1/Compositions/CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
        ));
    }

    public function testFetchResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "completed",
                "date_created": "2015-07-30T20:00:00Z",
                "date_completed": "2015-07-30T20:01:33Z",
                "date_deleted": null,
                "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "PAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "user*"
                ],
                "audio_sources_excluded": [
                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                ],
                "video_layout": {
                    "grid": {
                        "video_sources": [
                            "*"
                        ],
                        "video_sources_excluded": [
                            "MTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    },
                    "pip": {
                        "video_sources": [
                            "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                        ],
                        "video_sources_excluded": [],
                        "reuse": "none",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    }
                },
                "resolution": "1280x720",
                "format": "webm",
                "bitrate": 64,
                "size": 4,
                "duration": 6,
                "trim": true,
                "media_external_location": null,
                "encryption_key": null,
                "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositions("CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->fetch();

        $this->assertNotNull($actual);
    }

    public function testReadRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositions->read();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://video.twilio.com/v1/Compositions'
        ));
    }

    public function testReadEnqueuedResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "compositions": [],
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://video.twilio.com/v1/Compositions?Status=enqueued&PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/Compositions?Status=enqueued&PageSize=10&Page=0",
                    "next_page_url": null,
                    "key": "compositions"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositions->read();

        $this->assertNotNull($actual);
    }

    public function testReadEmptyResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "compositions": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/Compositions?Status=completed&PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/Compositions?Status=completed&PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "compositions"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositions->read();

        $this->assertNotNull($actual);
    }

    public function testReadResultsResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "compositions": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "completed",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_completed": "2015-07-30T20:01:33Z",
                        "date_deleted": null,
                        "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "audio_sources": [
                            "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "user*"
                        ],
                        "audio_sources_excluded": [],
                        "video_layout": {
                            "grid": {
                                "video_sources": [
                                    "user*"
                                ],
                                "video_sources_excluded": [],
                                "reuse": "show_oldest",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            },
                            "pip": {
                                "video_sources": [
                                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                                ],
                                "video_sources_excluded": [],
                                "reuse": "none",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            }
                        },
                        "resolution": "1280x720",
                        "format": "webm",
                        "bitrate": 64,
                        "size": 4,
                        "duration": 6,
                        "trim": true,
                        "media_external_location": null,
                        "encryption_key": null,
                        "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "links": {
                            "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/Compositions?Status=completed&RoomSid=RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa&DateCreatedAfter=2017-01-01T00%3A00%3A01Z&DateCreatedBefore=2017-12-31T23%3A59%3A59Z&PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/Compositions?Status=completed&RoomSid=RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa&DateCreatedAfter=2017-01-01T00%3A00%3A01Z&DateCreatedBefore=2017-12-31T23%3A59%3A59Z&PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "compositions"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositions->read();

        $this->assertNotNull($actual);
    }

    public function testDeleteRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositions("CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->delete();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'delete',
            'https://video.twilio.com/v1/Compositions/CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
        ));
    }

    public function testDeleteResponse() {
        $this->holodeck->mock(new Response(
            204,
            null
        ));

        $actual = $this->twilio->video->v1->compositions("CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")->delete();

        $this->assertTrue($actual);
    }

    public function testCreateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->video->v1->compositions->create("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('RoomSid' => "RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", );

        $this->assertRequest(new Request(
            'post',
            'https://video.twilio.com/v1/Compositions',
            null,
            $values
        ));
    }

    public function testCreateResponse() {
        $this->holodeck->mock(new Response(
            201,
            '
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "processing",
                "date_created": "2015-07-30T20:00:00Z",
                "date_completed": null,
                "date_deleted": null,
                "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "user*"
                ],
                "audio_sources_excluded": [
                    "RTbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                ],
                "video_layout": {
                    "custom": {
                        "video_sources": [
                            "user*"
                        ],
                        "video_sources_excluded": [
                            "RTcaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 800,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": [
                            2,
                            3
                        ]
                    }
                },
                "trim": true,
                "format": "mp4",
                "resolution": "1920x1080",
                "bitrate": 0,
                "size": 0,
                "duration": 0,
                "media_external_location": null,
                "encryption_key": null,
                "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                }
            }
            '
        ));

        $actual = $this->twilio->video->v1->compositions->create("RMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");

        $this->assertNotNull($actual);
    }
}