<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Voice\V1\DialingPermissions;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class BulkCountryUpdateTest extends HolodeckTestCase {
    public function testCreateRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->voice->v1->dialingPermissions
                                    ->bulkCountryUpdates->create("update_request");
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $values = array('UpdateRequest' => "update_request", );

        $this->assertRequest(new Request(
            'post',
            'https://voice.twilio.com/v1/DialingPermissions/BulkCountryUpdates',
            null,
            $values
        ));
    }

    public function testCreateResponse() {
        $this->holodeck->mock(new Response(
            201,
            '
            {
                "update_count": 1,
                "update_request": "accepted"
            }
            '
        ));

        $actual = $this->twilio->voice->v1->dialingPermissions
                                          ->bulkCountryUpdates->create("update_request");

        $this->assertNotNull($actual);
    }
}