<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Tests\Integration\Voice\V1\DialingPermissions\Country;

use Twilio\Exceptions\DeserializeException;
use Twilio\Exceptions\TwilioException;
use Twilio\Http\Response;
use Twilio\Tests\HolodeckTestCase;
use Twilio\Tests\Request;

class HighriskSpecialPrefixTest extends HolodeckTestCase {
    public function testReadRequest() {
        $this->holodeck->mock(new Response(500, ''));

        try {
            $this->twilio->voice->v1->dialingPermissions
                                    ->countries("US")
                                    ->highriskSpecialPrefixes->read();
        } catch (DeserializeException $e) {}
          catch (TwilioException $e) {}

        $this->assertRequest(new Request(
            'get',
            'https://voice.twilio.com/v1/DialingPermissions/Countries/US/HighRiskSpecialPrefixes'
        ));
    }

    public function testReadLvResponse() {
        $this->holodeck->mock(new Response(
            200,
            '
            {
                "content": [
                    {
                        "prefix": "+37181"
                    },
                    {
                        "prefix": "+3719000"
                    }
                ],
                "meta": {
                    "first_page_url": "https://voice.twilio.com/v1/DialingPermissions/Countries/LV/HighRiskSpecialPrefixes?PageSize=50&Page=0",
                    "key": "content",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/DialingPermissions/Countries/LV/HighRiskSpecialPrefixes?PageSize=50&Page=0"
                }
            }
            '
        ));

        $actual = $this->twilio->voice->v1->dialingPermissions
                                          ->countries("US")
                                          ->highriskSpecialPrefixes->read();

        $this->assertNotNull($actual);
    }
}